/*
 * CarregaImmobles.java
 *
 * Created on 29 de mayo de 2008, 16:22
 */

package servlets;

import java.io.*;
import java.net.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;
import locals.Immoble;

/**
 *
 * @author dai
 * @version
 */
public class CarregaImmobles extends HttpServlet {
    
    Connection con = null;
    DataSource ds = null;
    ArrayList <Immoble> immobles = new ArrayList();
    
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        
        if ( request.getSession().getAttribute("immobles") == null )
        {
            try {
                        Context contextoInicial = new InitialContext(); 
                        Context contexto = (Context) contextoInicial.lookup("java:comp/env");
                        
                        ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria"); 
                        con = ds.getConnection();
                        Statement st = con.createStatement();
                        ResultSet rs = st.executeQuery("SELECT id_immoble, adresa FROM immobles AS a LEFT JOIN locals AS b ON a.id_local = b.id_local LEFT JOIN adreses AS c ON b.id_adresa = c.id_adresa");
                        while ( rs.next() )
                        {
                            immobles.add(new Immoble(rs.getInt("id_immoble"), rs.getString("adresa")));
                        }
                       rs.close();
                       st.close();
                       con.close();
                } 
                catch(Exception e) { 
                        // el que sigui
                }
            finally
            {
                try
                {
                    if (con != null )
                    {
                        con.close();
                    }
                }
                catch (Exception ex){}
            }

            HttpSession sessio = request.getSession();
            sessio.setAttribute("immobles",immobles);
            //this.getServletContext().setAttribute("zones", zones);
        }
        
        //redirigim cap a l'altra pagina
        RequestDispatcher rD = request.getRequestDispatcher("/afegirLocals.jsp");
        rD.forward(request, response);
        
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
